<script>
document.addEventListener("DOMContentLoaded", function() {
  const svgElement = document.querySelector("svg#map-layer");
  const originalOrder = Array.from(svgElement.children); // Store the original order of the children

  svgElement.querySelectorAll("a").forEach(function(anchor) {
    anchor.addEventListener("mouseenter", function() {
      const group = this.querySelector("g");

      // Calculate the bounding box of the group
      const bbox = group.getBBox();

      // Calculate the center of the bounding box
      const centerX = bbox.x + bbox.width / 2;
      const centerY = bbox.y + bbox.height / 2;

      // Set the transform-origin to the center of the group
      group.style.transformOrigin = `${centerX}px ${centerY}px`;

      // Move the hovered group to the end of its parent's child list to bring it to the front
      svgElement.appendChild(this);
    });

    anchor.addEventListener("mouseleave", function() {
      // Find the original index of this element
      const originalIndex = originalOrder.indexOf(this);

      // Remove the element from its current position
      svgElement.removeChild(this);

      // Insert the element back to its original position
      if (originalIndex >= 0 && originalIndex < svgElement.children.length) {
        svgElement.insertBefore(this, svgElement.children[originalIndex]);
      } else {
        svgElement.appendChild(this);
      }
    });
  });
});
</script>